﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Telephone_Unformat
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda IsValidFormat() akceptuje argument w postaci ciągu tekstowego
        // i ustala, czy przedstawia on poprawnie sformatowany numer telefonu
        // w stylu stosowanym w USA, czyli w następujący sposób:
        // (XXX)XXX-XXXX
        // Jeżeli argumentem jest poprawnie sformatowany numer telefonu,
        // metoda zwraca true. W przeciwnym razie wartością zwrotną jest false.
        private bool IsValidFormat(string str)
        {
            const int VALID_LENGTH = 13; // Długość poprawnego ciągu tekstowego.
            bool valid;                 // Zmienna oznaczająca poprawność ciągu tekstowego.

            // Ustalenie, czy str to poprawnie sformatowany ciąg tekstowy.
            if (str.Length == VALID_LENGTH && str[0] == '(' &&
               str[4] == ')' && str[8] == '-')
            {
                valid = true;
            }
            else
            {
                valid = false;
            }

            // Zwrot wartości zmiennej valid.
            return valid;
        }

        // Metoda Unformat() akceptuje ciąg tekstowy przekazany przez
        // referencję i zawierający numer telefonu sformatowany w następujący
        // sposób: (XXX)XXX-XXXX.
        // Metoda usuwa formatowanie, pozbywając się z ciągu tekstowego
        // nawiasu i myślnika.
        private void Unformat(ref string str)
        {
            // Najpierw należy usunąć nawias otwierający w położeniu o indeksie 0.
            str = str.Remove(0, 1);

            // Następnie należy usunąć nawias zamykający. Z powodu
            // poprzedniej operacji usunięcia ten nawias znajduje
            // się teraz w położeniu 3.
            str = str.Remove(3, 1);

            // Później należy usunąć myślnik. Z powodu wcześniejszych
            // operacji usunięcia ten myślnik znajduje się teraz
            // w położeniu 6.
            str = str.Remove(6, 1);
        }

        private void unformatButton_Click(object sender, EventArgs e)
        {
            // Pobranie kopii danych wejściowych użytkownika bez białych znaków.
            string input = numberTextBox.Text.Trim();

            // Jeżeli dane wejściowe to poprawnie sformatowany numer telefonu
            // należy usunąć z niego formatowanie i wyświetlić go.
            if (IsValidFormat(input))
            {
                Unformat(ref input);
                MessageBox.Show(input);
            }
            else
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show("Nieprawidłowe dane wejściowe");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
